% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realize.R
\name{ensure_realized}
\alias{ensure_realized}
\title{Memoized MC fallback materialization.}
\usage{
ensure_realized(x, n = 10000L)
}
\arguments{
\item{x}{A distribution object.}

\item{n}{Number of samples (default: 10000).}
}
\value{
An \code{empirical_dist} (or \code{realized_dist}).
}
\description{
Single internal entry point for all Monte Carlo fallback paths.
If \code{x} is already an \code{empirical_dist}, returns it unchanged.
If \code{x} has a \code{.cache} environment (e.g. \code{edist} objects),
caches the realization so that multiple method calls (e.g. \code{cdf} +
\code{density}) share the same samples.  Sample-size-aware: if the cached
realization has fewer than \code{n} samples, re-realizes.
}
\keyword{internal}
