% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniform_dist.R
\name{inv_cdf.uniform_dist}
\alias{inv_cdf.uniform_dist}
\title{Inverse CDF (quantile function) for a uniform distribution.}
\usage{
\method{inv_cdf}{uniform_dist}(x, ...)
}
\arguments{
\item{x}{A \code{uniform_dist} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(p, lower.tail = TRUE, log.p = FALSE, ...)}
returning the quantile at probability \code{p}.
}
\description{
Returns a function that computes quantiles of the uniform distribution.
}
\examples{
x <- uniform_dist(0, 10)
q <- inv_cdf(x)
q(0.5)
q(0.9)
}
