% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_enhanced.R
\name{anki_find_similar}
\alias{anki_find_similar}
\title{Search cards by content similarity}
\usage{
anki_find_similar(
  query,
  path = NULL,
  profile = NULL,
  n = 10,
  method = "tfidf",
  within_deck = FALSE
)
}
\arguments{
\item{query}{Either a card ID or text to search for similar cards}

\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{n}{Number of similar cards to return (default 10)}

\item{method}{Similarity method: "tfidf", "jaccard", or "ngram"}

\item{within_deck}{Only search within same deck as query card}
}
\value{
A tibble with similar cards and similarity scores
}
\description{
Find cards with similar content to a given card or text.
}
\examples{
\dontrun{
# Find cards similar to card ID 1234567890
anki_find_similar(1234567890)

# Find cards similar to specific text
anki_find_similar("mitochondria powerhouse")
}
}
