% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forgetting_curve.R
\name{anki_fit_forgetting_curve}
\alias{anki_fit_forgetting_curve}
\title{Fit forgetting curve from review data}
\usage{
anki_fit_forgetting_curve(
  path = NULL,
  profile = NULL,
  cid = NULL,
  min_reviews = 5,
  max_cards = 1000
)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{cid}{Optional card ID for individual card analysis}

\item{min_reviews}{Minimum reviews required for analysis (default 5)}

\item{max_cards}{Maximum cards to analyze for aggregate (default 1000)}
}
\value{
A list with fitted curve parameters and comparison data
}
\description{
Fits a forgetting curve to actual review data and compares it to the
theoretical FSRS curve. Can analyze individual cards or aggregate data.
}
\examples{
\dontrun{
curve <- anki_fit_forgetting_curve()
plot(curve$data$days_elapsed, curve$data$observed_retention, type = "p")
lines(curve$data$days_elapsed, curve$data$fitted_retention, col = "blue")
}
}
