% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{anki_leeches}
\alias{anki_leeches}
\title{Find leech cards (high lapse count)}
\usage{
anki_leeches(path = NULL, profile = NULL, threshold = 8, include_notes = FALSE)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{threshold}{Minimum number of lapses to consider a leech (default 8)}

\item{include_notes}{If TRUE, join with note data}
}
\value{
A tibble of leech cards ordered by lapses
}
\description{
Leeches are cards that you keep forgetting. By default, Anki marks cards
as leeches after 8 lapses.
}
\examples{
\dontrun{
leeches <- anki_leeches()
leeches <- anki_leeches(threshold = 5)
}
}
