% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burnout_quality.R
\name{anki_review_quality}
\alias{anki_review_quality}
\title{Review Quality Score}
\usage{
anki_review_quality(
  path = NULL,
  profile = NULL,
  days = 30,
  min_time_ms = 800,
  max_time_ms = 60000
)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{days}{Number of days to analyze (default 30)}

\item{min_time_ms}{Minimum expected review time in ms (default 800)}

\item{max_time_ms}{Maximum expected review time in ms (default 60000)}
}
\value{
A list with quality metrics and flagged reviews
}
\description{
Detects low-quality reviews: pattern clicking, rushed reviews,
suspicious timing patterns, and other indicators of disengaged studying.
}
\examples{
\dontrun{
quality <- anki_review_quality()
quality$score
quality$issues
}
}
