% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection.R
\name{fsrs_interval}
\alias{fsrs_interval}
\title{Calculate next interval for desired retention}
\usage{
fsrs_interval(stability, desired_retention = 0.9, decay = 0.5)
}
\arguments{
\item{stability}{Stability (S) in days}

\item{desired_retention}{Target retention rate (default 0.9 = 90\%)}

\item{decay}{Decay parameter (w20). Default 0.5 is FSRS-4.5 value.}
}
\value{
Interval in days until next review
}
\description{
Given a stability value and desired retention, calculates how many days
until the card should be reviewed.
}
\details{
Derived from the retrievability formula by solving for t:
\deqn{I(r, S) = S / factor \cdot (r^{-1/decay} - 1)}
}
\examples{
\dontrun{
# When should a card with 30-day stability be reviewed for 90\% retention?
}
\dontrun{
\dontrun{
fsrs_interval(stability = 30, desired_retention = 0.9)
}
}
}
\keyword{internal}
