% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection.R
\name{fsrs_retrievability}
\alias{fsrs_retrievability}
\title{Calculate retrievability for FSRS cards}
\usage{
fsrs_retrievability(stability, days_elapsed, decay = 0.5)
}
\arguments{
\item{stability}{Stability (S) in days - time for R to drop from 100\% to 90\%}

\item{days_elapsed}{Days since last review (t)}

\item{decay}{Decay parameter (w20). In FSRS-6, this is optimized per-user,
typically between 0.1-0.8. Default 0.5 is FSRS-4.5 value. Use per-card
decay from \code{anki_cards_fsrs()} for best accuracy.}
}
\value{
Retrievability (R), probability of recall between 0 and 1
}
\description{
Computes the current probability of recall using the FSRS-6 power forgetting
curve formula. This is the formula used by Anki 24.11+ with FSRS-6.
}
\details{
The FSRS-6 forgetting curve formula is:
\deqn{R(t, S) = (1 + factor \cdot t / S)^{-decay}}
where \code{factor = 0.9^(-1/decay) - 1}.

When \code{t = S}, retrievability equals 90\% by definition.
}
\examples{
# Card with 30-day stability reviewed 15 days ago
\dontrun{
fsrs_retrievability(stability = 30, days_elapsed = 15)
}
}
\keyword{internal}
