% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance.R
\name{balance_ann}
\alias{balance_ann}
\title{Functional balance of a tree}
\usage{
balance_ann(phy)
}
\arguments{
\item{phy}{An object of class \link{aphylo} or \link{multiAphylo}}
}
\value{
If \code{phy} is an object of class \code{phylo}, a single scalar, otherwise,
it returns a vector of length \code{\link{Ntrees}}\code{(phy)}.
}
\description{
This function computes the distance between .5 and the observed proportion
of ones for each function in a tree.
}
\details{
Functional balance is defined as follows

\deqn{%
P^{-1}\sum_{p}\left(1 - \left|0.5 - N^{-1}\sum_n a_{np}\right|\right)
}{%
mean(1 - abs(.5 - colMeans(A)))
}

Where \code{A} is the matrix of annotations.

With values ranging between 0 and 1, one been perfect balance, this is, equal
number of zeros and ones in the annotations. In the case of multiple functions,
as noted in the formula, the balance is the average across functions.
}
\examples{
x <- raphylo(20, P = 2)
balance_ann(x)

balance_ann(c(x, x))

}
