# utils.R

#' Replace NA values with sentinel value
#'
#' @param x Numeric vector
#' @param sentinel Numeric value used to replace NA
#'
#' @return Numeric vector
#' @keywords internal
replace_na_with <- function(x, sentinel = 999) {
  x[is.na(x)] <- sentinel
  x
}


#' Check for duplicate values
#'
#' @param x Character vector
#'
#' @return Logical. TRUE if duplicates exist.
#' @export
has_duplicates <- function(x) {
  x <- x[x != ""]
  any(duplicated(x))
}

#' Fill prior parameters into a bias specification
#'
#' @keywords internal
fill_bias_priors <- function(
    bias_spec,
    ab_params = list(),
    skn_params = list(),
    de_params = list(),
    ex_params = list(),
    exneg_params = list()
) {

  for (i in seq_len(bias_spec$NN)) {

    if (bias_spec$b[i] != 999) {
      vals <- ab_params[[names(appraise::bias_map)[bias_spec$b[i]]]]
      bias_spec$ab_values[(2*i-1):(2*i)] <- vals
    }

    if (bias_spec$s[i] != 999) {
      vals <- skn_params[[names(appraise::bias_map)[bias_spec$s[i]]]]
      bias_spec$skn_values[(3*i-2):(3*i)] <- vals
    }

    if (bias_spec$d[i] != 999) {
      vals <- de_params[[names(appraise::bias_map)[bias_spec$d[i]]]]
      bias_spec$de_values[(2*i-1):(2*i)] <- vals
    }

    if (bias_spec$e[i] != 999) {
      bias_spec$ex_values[i] <- ex_params[[names(appraise::bias_map)[bias_spec$e[i]]]]
    }

    if (bias_spec$en[i] != 999) {
      bias_spec$exneg_values[i] <- exneg_params[[names(appraise::bias_map)[bias_spec$en[i]]]]
    }
  }

  bias_spec
}
