% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_EQD_HOR}
\alias{astro_rotation_EQD_HOR}
\title{Rotation Matrix from EQD to HOR}
\usage{
astro_rotation_EQD_HOR(time, latitude, longitude, height)
}
\arguments{
\item{time}{A POSIXct object representing the date and time at which the Earth's
equator applies.}

\item{latitude}{The observer's geographic latitude in degrees.}

\item{longitude}{The observer's geographic longitude in degrees.}

\item{height}{The observer's elevation above sea level in meters.}
}
\value{
A rotation matrix that converts EQD to HOR. The components of the horizontal
vector are: x = north, y = west, z = zenith (straight up from the observer).
}
\description{
Calculates a rotation matrix from equatorial of-date (EQD) to horizontal (HOR).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: EQD = equatorial system, using equator of the specified date/time.

\strong{Target}: HOR = horizontal system (x = north, y = west, z = zenith).
}
\examples{
astro_rotation_EQD_HOR(Sys.time(), latitude = -35.28, longitude = 149.12, height = 0)

}
