% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observer.R
\name{astro_vector_observer}
\alias{astro_vector_observer}
\title{Geographic coordinates from observer position vector}
\usage{
astro_vector_observer(vector, of_date = FALSE)
}
\arguments{
\item{vector}{A list with components representing the observer's position vector:
\describe{
\item{x}{Equatorial x-coordinate in AU}
\item{y}{Equatorial y-coordinate in AU}
\item{z}{Equatorial z-coordinate in AU}
\item{t}{The time (POSIXct) at which the vector is valid}
}
The components are expressed in Astronomical Units (AU).
Divide kilometers by #KM_PER_AU to convert to AU.}

\item{of_date}{Logical. If \code{TRUE}, interprets \code{vector} as equator-of-date coordinates.
If \code{FALSE} (default), interprets it as J2000 coordinates.}
}
\value{
A list with components:
\describe{
\item{latitude}{Geographic latitude in degrees north of the equator (range: -90 to +90)}
\item{longitude}{Geographic longitude in degrees east of the prime meridian (range: 0 to 360)}
\item{height}{Elevation above sea level in meters}
}
}
\description{
Given a geocentric equatorial position vector, calculates the geographic
latitude, longitude, and elevation of the observer on Earth's surface.
This is the inverse function of \code{\link[=astro_observer_vector]{astro_observer_vector()}}.
}
\examples{
# Convert a position vector back to geographic coordinates
obs_vec <- list(
  x = 0.00005, y = 0.00005, z = 0.00005,
  t = as.POSIXct("2024-01-01 12:00:00", tz = "UTC")
)
obs <- astro_vector_observer(obs_vec)
obs
}
