% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsis.R
\name{next_lunar_apsis}
\alias{next_lunar_apsis}
\title{Find the next lunar apsis event}
\usage{
next_lunar_apsis(apsis)
}
\arguments{
\item{apsis}{A list returned from \code{search_lunar_apsis()} or a previous call
to \code{next_lunar_apsis()}.}
}
\value{
A list with the same structure as \code{search_lunar_apsis()}:
\describe{
\item{time}{A \code{POSIXct} datetime of the next lunar apsis.}
\item{kind}{Integer code: 0 for perigee, 1 for apogee.}
\item{dist_au}{Distance in astronomical units.}
\item{dist_km}{Distance in kilometers.}
}
}
\description{
Given a lunar apsis event (perigee or apogee), finds the next apsis event
in the series. This function alternates between finding perigees and apogees.
}
\examples{
start <- as.POSIXct("2025-01-01", tz = "UTC")
apsis1 <- search_lunar_apsis(start)
apsis2 <- next_lunar_apsis(apsis1)
apsis3 <- next_lunar_apsis(apsis2)
}
