% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transit.R
\name{search_local_solar_eclipse}
\alias{search_local_solar_eclipse}
\title{Search for a local solar eclipse}
\usage{
search_local_solar_eclipse(start_time, latitude, longitude)
}
\arguments{
\item{start_time}{A \code{POSIXct} date/time for starting the search.}

\item{latitude}{Latitude of the observer in degrees (-90 to 90).}

\item{longitude}{Longitude of the observer in degrees (-180 to 180).}
}
\value{
A list containing:
\describe{
\item{status}{Status code (0 = success).}
\item{kind}{Type of eclipse: 0 = partial, 1 = annular, 2 = total.}
\item{partial_begin}{Start of partial eclipse (list with \code{time} and \code{altitude}).}
\item{total_begin}{Start of total/annular eclipse (list with \code{time} and \code{altitude}).}
\item{peak}{Peak of eclipse (list with \code{time} and \code{altitude}).}
\item{total_end}{End of total/annular eclipse (list with \code{time} and \code{altitude}).}
\item{partial_end}{End of partial eclipse (list with \code{time} and \code{altitude}).}
}
}
\description{
Searches for the first solar eclipse visible at a specific location on Earth's
surface that occurs after the given start time. Note: an eclipse reported by
this function might be partly or completely invisible due to the time of day.
To find a series of eclipses, use \code{next_local_solar_eclipse} with the
\code{peak} time from the previous result.
}
\examples{
start <- as.POSIXct("2025-01-01", tz = "UTC")
eclipse <- search_local_solar_eclipse(start, latitude = 37.77, longitude = -122.41)
}
