% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential-cached-token.R
\name{CachedTokenCredential}
\alias{CachedTokenCredential}
\title{Cached token credential authentication}
\description{
A credential class that retrieves tokens from the cache only, without
triggering interactive authentication flows. This is useful for non-interactive
sessions where you want to use previously cached tokens from DeviceCode or
AuthCode credentials.
}
\details{
This credential attempts to retrieve cached tokens from a chain of interactive
credentials (AuthCode and DeviceCode by default). It will not prompt for new
authentication - it only returns tokens that are already cached.

This is particularly useful for:
\itemize{
\item Non-interactive R sessions (e.g., scheduled scripts, CI/CD)
\item Scenarios where you've previously authenticated interactively and want
to reuse those cached tokens
}
}
\examples{
\dontrun{
# Create credential with default settings
cred <- CachedTokenCredential$new(
  scope = "https://graph.microsoft.com/.default",
  tenant_id = "my-tenant-id"
)

# Get a cached token (will fail if no cached token exists)
token <- cred$get_token()

# Use with httr2 request
req <- httr2::request("https://graph.microsoft.com/v1.0/me")
req <- cred$req_auth(req)
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.scope}}{Character string specifying the authentication scope.}

\item{\code{.tenant_id}}{Character string specifying the tenant ID.}

\item{\code{.client_id}}{Character string specifying the client ID.}

\item{\code{.chain}}{List of credential classes to attempt for cached tokens.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{provider}}{Lazily initialized credential provider}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CachedTokenCredential-new}{\code{CachedTokenCredential$new()}}
\item \href{#method-CachedTokenCredential-get_token}{\code{CachedTokenCredential$get_token()}}
\item \href{#method-CachedTokenCredential-req_auth}{\code{CachedTokenCredential$req_auth()}}
\item \href{#method-CachedTokenCredential-clone}{\code{CachedTokenCredential$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CachedTokenCredential-new"></a>}}
\if{latex}{\out{\hypertarget{method-CachedTokenCredential-new}{}}}
\subsection{Method \code{new()}}{
Create a new CachedTokenCredential object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CachedTokenCredential$new(
  scope = NULL,
  tenant_id = NULL,
  client_id = NULL,
  chain = cached_token_credential_chain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scope}}{Optional character string specifying the authentication scope.}

\item{\code{tenant_id}}{Optional character string specifying the tenant ID for
authentication.}

\item{\code{client_id}}{Optional character string specifying the client ID for
authentication.}

\item{\code{chain}}{A list of credential classes to attempt for cached tokens.
Defaults to AuthCodeCredential and DeviceCodeCredential.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{CachedTokenCredential} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CachedTokenCredential-get_token"></a>}}
\if{latex}{\out{\hypertarget{method-CachedTokenCredential-get_token}{}}}
\subsection{Method \code{get_token()}}{
Get an access token from the cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CachedTokenCredential$get_token()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{\link[httr2:oauth_token]{httr2::oauth_token()}} object containing the access token
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CachedTokenCredential-req_auth"></a>}}
\if{latex}{\out{\hypertarget{method-CachedTokenCredential-req_auth}{}}}
\subsection{Method \code{req_auth()}}{
Add authentication to an httr2 request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CachedTokenCredential$req_auth(req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{An \code{\link[httr2:request]{httr2::request()}} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The request object with authentication configured
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CachedTokenCredential-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CachedTokenCredential-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CachedTokenCredential$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
