% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{Lin}
\alias{Lin}
\title{Linear Prior with Independent Normal Errors}
\usage{
Lin(s = 1, mean_slope = 0, sd_slope = 1, along = NULL, con = c("none", "by"))
}
\arguments{
\item{s}{Scale for the prior for the errors.
Default is \code{1}. Can be \code{0}.}

\item{mean_slope}{Mean in prior for slope
of line. Default is 0.}

\item{sd_slope}{Standard deviation in prior for slope
of line. Default is 1.}

\item{along}{Name of the variable to be used
as the 'along' variable. Only used with
interactions.}

\item{con}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Constraints on parameters.
Current choices are \code{"none"} and \code{"by"}.
Default is \code{"none"}. See below for details.}
}
\value{
An object of class \code{"bage_prior_lin"}.
}
\description{
Use a line or lines with independent
normal errors to model a main effect
or interaction. Typically used with time.
}
\details{
If \code{Lin()} is used with an interaction,
then separate lines are constructed along
the 'along' variable, within each combination
of the 'by' variables.

Argument \code{s} controls the size of the errors.
Smaller values give smoother estimates.
\code{s} can be zero, in which case errors are zero,
and all values lie exactly on straight lines.
This is clearly a simplification, but it allows
the prior to be used with very large
interactions.

Argument \code{sd_slope} controls the size of the slopes of
the lines. Larger values can give more steeply
sloped lines.
}
\section{Mathematical details}{


When \code{Lin()} is used with a main effect,

\deqn{\beta_j = (j - (J+1)/2) \eta + \epsilon_j}
\deqn{\eta \sim \text{N}(\mathtt{mean\_slope}, \mathtt{sd\_slope}^2)}
\deqn{\epsilon_j \sim \text{N}(0, \tau^2),}

and when it is used with an interaction,

\deqn{\beta_{u,v} = (v - (V + 1)/2) \eta_u + \epsilon_{u,v}}
\deqn{\eta_u \sim \text{N}(\mathtt{mean\_slope}, \mathtt{sd\_slope}^2)}
\deqn{\epsilon_{u,v} \sim \text{N}(0, \tau^2),}

where
\itemize{
\item \eqn{\pmb{\beta}} is the main effect or interaction;
\item \eqn{j} denotes position within the main effect;
\item \eqn{v} denotes position within the 'along' variable of the interaction; and
\item \eqn{u} denotes position within the 'by' variable(s) of the interaction.
}

Parameter \eqn{\tau} has a half-normal prior
\deqn{\tau \sim \text{N}^+(0, \mathtt{s}^2).}

When \eqn{\mathtt{s} = 0}, the model reduces to

\deqn{\beta_j = (j - (J+1)/2) \eta}
\deqn{\eta \sim \text{N}(\mathtt{mean\_slope}, \mathtt{sd\_slope}^2)}

or

\deqn{\beta_{u,v} = (v = (V + 1)/2) \eta_u}
\deqn{\eta_u \sim \text{N}(\mathtt{mean\_slope}, \mathtt{sd\_slope}^2)}.
}

\section{Constraints}{


\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} The specification of
constraints is likely to change in future versions of \pkg{bage}.

With some combinations of terms and priors, the values of
the intercept, main effects, and interactions are
are only weakly identified.
For instance, it may be possible to increase the value of the
intercept and reduce the value of the remaining terms in
the model with no effect on predicted rates and only a tiny
effect on prior probabilities. This weak identifiability is
typically harmless. However, in some applications, such as
when trying to obtain interpretable values
for main effects and interactions, it can be helpful to increase
identifiability through the use of constraints, specified through the
\code{con} argument.

Current options for \code{con} are:
\itemize{
\item \code{"none"} No constraints. The default.
\item \code{"by"} Only used in interaction terms that include 'along' and
'by' dimensions. Within each value of the 'along'
dimension, terms across each 'by' dimension are constrained
to sum to 0.
}
}

\examples{
Lin()
Lin(s = 0.5, sd_slope = 2)
Lin(s = 0)
Lin(along = "cohort")
}
\seealso{
\itemize{
\item \code{\link[=Lin_AR]{Lin_AR()}} Linear with AR errors
\item \code{\link[=Lin_AR1]{Lin_AR1()}} Linear with AR1 errors
\item \code{\link[=RW2]{RW2()}} Second-order random walk
\item \link{priors} Overview of priors implemented in \pkg{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
\item \href{https://bayesiandemography.github.io/bage/articles/vig02_math.html}{Mathematical Details}
vignette
}
}
