% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_plot.R
\name{bayes_plot_var}
\alias{bayes_plot_var}
\title{Plot variance maps}
\usage{
bayes_plot_var(
  x,
  labels = NULL,
  quantile = 0.75,
  n = 15,
  style = "equal",
  palette = "YlGnBu",
  tmap_scale = 1
)
}
\arguments{
\item{x}{SpatRaster to be plotted.}

\item{labels}{Labels to be plotted}

\item{quantile}{Thereshold of values to be plotted}

\item{n}{Preferred number of classes}

\item{style}{Method to process the color scale}

\item{palette}{An RColorBrewer palette}

\item{tmap_scale}{Global scale parameter for map (default: 1.5)}
}
\value{
A plot object
}
\description{
Plot variance maps
}
\examples{
if (bayes_run_examples()) {
    # get the probability file
    data_dir <- system.file("/extdata/probs/", package = "bayesEO")
    file <- list.files(data_dir)
    # build the full path
    probs_file <- paste0(data_dir, "/", file)
    # include the labels
    labels <- c("Water", "ClearCut_Burn", "ClearCut_Soil",
             "ClearCut_Veg", "Forest", "Wetland")
    # associate the labels to the names of the SpatRaster
    probs <- bayes_read_probs(probs_file, labels)
    # calculate the variance
    var <- bayes_variance(probs)
    # Plot the variance image
    bayes_plot_var(var,
        n = 15,
        style = "order",
        quantile = 0.75,
        palette = "YlGn",
        labels = c("Forest", "ClearCut_Veg"))
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
