% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{residuals.bayesianVARs_bvar}
\alias{residuals.bayesianVARs_bvar}
\title{Extract Model Residuals}
\usage{
\method{residuals}{bayesianVARs_bvar}(object, ...)
}
\arguments{
\item{object}{A \code{bayesianVARs_bvar} object estimated via \code{\link[=bvar]{bvar()}}.}

\item{...}{Passed to \code{\link[=fitted.bayesianVARs_bvar]{fitted.bayesianVARs_bvar()}}.}
}
\value{
An object of class \code{bayesianVARs_residuals}.
}
\description{
Extract model residuals, defined as the difference between the observed
time-series and the in-sample predictions of the VAR model. Because
in-sample prediction is subject to uncertainty of the VAR parameter
estimates, this uncertainty carries over to the model residuals.
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Estimate a model
mod <- bvar(data, sv_keep = "all", quiet = TRUE)

mod.resids <- residuals(mod)
plot(mod.resids)
}
\seealso{
\code{\link{fitted.bayesianVARs_bvar}}
}
