% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma_inference.R
\name{bma_inference}
\alias{bma_inference}
\title{Bayesian model averaging}
\usage{
bma_inference(
  formula,
  data,
  zellner_g = nrow(data),
  CI_level = 0.95,
  ROPE,
  mcmc_draws = 10000,
  n_models = 500,
  mc_error = 0.001,
  seed = 1,
  ...
)
}
\arguments{
\item{formula}{A formula specifying the model.}

\item{data}{Data used in linear regression model}

\item{zellner_g}{numeric.  Positive number giving the value of "g" in Zellner's
g prior.}

\item{CI_level}{Level for credible interval}

\item{ROPE}{vector of positive values giving ROPE boundaries for each regression
coefficient.  Optionally, you can not include a ROPE boundary for the intercept.
If missing, defaults go to those suggested by Kruchke (2018).}

\item{mcmc_draws}{Integer. Number of draws passed into \code{\link[BMS]{bms}}}

\item{n_models}{Integer. The number of best models for which information is stored.
See \code{\link[BMS]{bms}} for more details.}

\item{mc_error}{The number of posterior draws will ensure that with 99\%
probability the bounds of the credible intervals will be within \eqn{\pm}
\code{mc_error}\eqn{\times 4s_y}, that is, within 100\code{mc_error}\% of the
trimmed range of y.}

\item{seed}{Integer. Always set your seed!!!}

\item{...}{Other arguments for \code{\link[BMS]{bms}}.}
}
\value{
A list with the following elements:
\itemize{
\item summary Tibble with point and interval estimates
\item lm_b_fits A list of lm_b fits using zellner's g prior for
all the top models from \code{\link[BMS]{bms}}
\item hyperparameters A named list with the user-specified zellner's g value.
\item posterior_draws matrix of posterior draws of the regression parameters,
marginalizing out the model
}
}
\description{
Estimates and CIs from BMA
}
\details{
\code{bma_inference} leverages the \code{bms} function from its
eponymous R package, and then uses \code{lm_b} to obtain inference
on the regression coefficients for Bayesian model averaging.
}
\examples{
\donttest{
# Create data
set.seed(2025)
N = 500
test_data = 
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5],
             x4 = rnorm(N),
             x5 = rnorm(N),
             x6 = rnorm(N),
             x7 = rnorm(N),
             x8 = rnorm(N),
             x9 = rnorm(N),
             x10 = rnorm(N))
test_data$outcome = 
  rnorm(N,-1 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) )

# Fit linear model using Bayesian model averaging
fit <-
  bma_inference(outcome ~ .,
                test_data,
                user.int = FALSE)
summary(fit)
coef(fit)
credint(fit)
plot(fit)
}

}
