% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcfrailph.control.R
\name{bcfrailph.control}
\alias{bcfrailph.control}
\title{Arguments for controlling bcfrailph fits.}
\usage{
bcfrailph.control(
  max.iter = 400,
  tol = 1e-04,
  reltol = 1e-06,
  eval.max = 500,
  iter.max = 500,
  trace = 0,
  abs.tol = 1e-20,
  rel.tol = 1e-10,
  x.tol = 1.5e-08,
  xf.tol = 2.2e-14,
  step.min = 1,
  step.max = 1,
  met = 0
)
}
\arguments{
\item{max.iter}{Maximum number of outer iterations. The default is 400.}

\item{tol}{A absolute tolerance for convergence in gamma frailty fit. The default is 1e-04.}

\item{reltol}{Relative tolerance for convergence in lognormal frailty fit.The default is 1e-06.}

\item{eval.max}{argument used to control \link{nlminb} fits used.}

\item{iter.max}{argument used to control \link{nlminb} fits used.}

\item{trace}{argument used to control \link{nlminb} fits used.}

\item{abs.tol}{argument used to control \link{nlminb} fits used.}

\item{rel.tol}{argument used to control \link{nlminb} fits used.}

\item{x.tol}{argument used to control \link{nlminb} fits used.}

\item{xf.tol}{argument used to control \link{nlminb} fits used.}

\item{step.min}{argument used to control \link{nlminb} fits used.}

\item{step.max}{argument used to control \link{nlminb} fits used.}

\item{met}{procedure of optim method used.}
}
\value{
A list of control parameters.
}
\description{
This is used to set various numeric parameters controlling a bcfrailph model fits.
}
\seealso{
\code{\link{bcfrailph}},\code{\link{shrgamsp}}
}
