% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bids.R
\name{bids_heatmap}
\alias{bids_heatmap}
\title{Create a specialized heatmap visualization of BIDS data}
\usage{
bids_heatmap(
  x,
  interactive = TRUE,
  color_scheme = "viridis",
  file_type = "func",
  highlight_missing = TRUE,
  text_size = 2.5,
  rotate_labels = TRUE
)
}
\arguments{
\item{x}{A \code{bids_project} object}

\item{interactive}{Logical. Whether to create an interactive plot (default TRUE)}

\item{color_scheme}{Character. Name of the color palette to use (default "viridis")}

\item{file_type}{Character. Type of files to visualize (default "func")}

\item{highlight_missing}{Logical. Whether to highlight missing data points (default TRUE)}

\item{text_size}{Numeric. Size of text labels (default 2.5)}

\item{rotate_labels}{Logical. Whether to rotate the axis labels (default TRUE)}
}
\value{
A plot object (ggplot2 or plotly depending on interactive parameter)
}
\description{
This function creates a heatmap visualization of a BIDS project, where the x-axis represents
subjects and the y-axis represents tasks by run. Each cell in the heatmap is colored by
file size, providing an intuitive view of data completeness and size distribution across
the project. This is particularly useful for quality control and identifying missing data.
}
\examples{
\donttest{
# Create a basic interactive heatmap for a BIDS dataset
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  bids_heatmap(proj)
  
  # Create a static heatmap with custom settings
  bids_heatmap(proj, 
               interactive = FALSE,
               color_scheme = "plasma",
               text_size = 3,
               rotate_labels = FALSE)
  
  # Visualize anatomical data with missing data highlighted
  bids_heatmap(proj, 
               file_type = "anat",
               highlight_missing = TRUE,
               color_scheme = "magma")
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
