% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bids.R
\name{flat_list}
\alias{flat_list}
\alias{flat_list.bids_project}
\title{Get "flat" representation of BIDS Project}
\usage{
flat_list(x, ...)

\method{flat_list}{bids_project}(x, full_path = TRUE, ...)
}
\arguments{
\item{x}{the \code{bids_project} object}

\item{...}{extra args passed to methods}

\item{full_path}{If TRUE, return full paths to files; if FALSE, return just file names (default: TRUE)}
}
\value{
A data frame containing either full paths to files (if \code{full_path=TRUE}) or
just the file names (if \code{full_path=FALSE}). Each row represents one file in the BIDS project.
}
\description{
This function returns a flattened (non-hierarchical) representation of a BIDS project
formatted as a data frame. It extracts file paths or file names from the BIDS tree
structure, filtering for entries that start with "sub-" to focus on subject-level data.
}
\examples{
\donttest{
# Get flat representation with full paths
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  flat_list(proj)
  
  # Get flat representation with just file names
  flat_list(proj, full_path=FALSE)
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
