% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bid_structure.R
\name{bid_structure}
\alias{bid_structure}
\title{Document Dashboard Structure Stage in BID Framework}
\usage{
bid_structure(
  previous_stage,
  concepts = NULL,
  telemetry_flags = NULL,
  quiet = NULL,
  ...
)
}
\arguments{
\item{previous_stage}{A tibble or list output from an earlier BID stage
function.}

\item{concepts}{A character vector of additional BID concepts to include.
Concepts can be provided in natural language (e.g., "Principle of
Proximity") or with underscores (e.g., "principle_of_proximity"). The
function uses fuzzy matching to identify the concepts. If NULL, will
detect relevant concepts from previous stages automatically.}

\item{telemetry_flags}{Optional named list of telemetry flags from bid_flags().
Used to adjust suggestion scoring based on observed user behavior patterns.}

\item{quiet}{Logical indicating whether to suppress informational messages.
If NULL, uses getOption("bidux.quiet", FALSE).}

\item{...}{Additional parameters (reserved for future use).}
}
\value{
A bid_stage object containing:
\item{stage}{"Structure"}
\item{suggestions}{List of concept groups with ranked suggestions (nested format)}
\item{suggestions_tbl}{Flattened tibble with all suggestions, includes columns:
concept, title, details, components, rationale, score, difficulty, category}
\item{concepts}{Comma-separated string of all concepts used}
}
\description{
This function documents the structure of the dashboard and generates ranked,
concept-grouped actionable UI/UX suggestions. Returns structured recommendations
with specific component pointers and implementation rationales.
}
\details{
\strong{Suggestion Engine}: Generates ranked, actionable recommendations grouped
by UX concepts. Each suggestion includes specific R dashboard components
(Shiny, bslib, DT, plotly, etc.), implementation details, and rationale.
Suggestions are scored based on relevance and contextual factors. Component
suggestions work with both Shiny applications and Quarto dashboards, with
shiny-prefixed components (i.e., \verb{shiny::}) requiring Shiny runtime.
}
\examples{
notice_result <- bid_interpret(
  central_question = "How can we simplify data presentation?",
  data_story = new_data_story(
    hook = "Data is too complex",
    context = "Overloaded with charts",
    tension = "Confusing layout",
    resolution = "Introduce clear grouping"
  )
) |>
  bid_notice(
    problem = "Users struggle with information overload",
    evidence = "Survey results indicate delays"
  )

# Generate concept-grouped suggestions
structure_result <- bid_structure(previous_stage = notice_result)
print(structure_result$suggestions) # Ranked suggestions by concept (nested)

# Access flattened tibble format for easier manipulation
suggestions_flat <- structure_result$suggestions_tbl[[1]]
print(suggestions_flat)

# Filter by difficulty
easy_suggestions <- suggestions_flat[suggestions_flat$difficulty == "Easy", ]

# Filter by category
layout_suggestions <- suggestions_flat[suggestions_flat$category == "Layout", ]

summary(structure_result)

}
