% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_ingest.R
\name{detect_otel_json}
\alias{detect_otel_json}
\title{Detect if JSON file contains OTLP (OpenTelemetry Protocol) data}
\usage{
detect_otel_json(source_path)
}
\arguments{
\item{source_path}{Path to JSON file}
}
\value{
Logical TRUE if OTLP format detected, FALSE otherwise
}
\description{
Checks if a JSON file contains OpenTelemetry Protocol span data by looking
for the characteristic OTLP structure (resourceSpans, scopeSpans, spans).
}
\examples{
\dontrun{
detect_otel_json("spans.json") # returns TRUE for otlp files
detect_otel_json("telemetry.json") # returns FALSE for shiny.telemetry files
}
}
\keyword{internal}
