% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_otel_conversion.R
\name{extract_input_id_from_span}
\alias{extract_input_id_from_span}
\title{Extract input ID from span name or attributes}
\usage{
extract_input_id_from_span(span_name, span_attributes)
}
\arguments{
\item{span_name}{Character span name}

\item{span_attributes}{List or data frame of span attributes}
}
\value{
Character input ID, or NA if not found
}
\description{
Extracts input identifier from OTLP span. Looks in span name (e.g., "reactive:input$slider1")
and span attributes (e.g., input_id attribute).
}
\examples{
\dontrun{
# extract from span name
extract_input_id_from_span("reactive:input$slider1", NULL) # returns "slider1"

# extract from attributes
attrs <- list(list(key = "input_id", value = list(stringValue = "text1")))
extract_input_id_from_span("reactive", attrs) # returns "text1"
}
}
\keyword{internal}
