% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_aberrations.R
\name{calculate_aberr_table}
\alias{calculate_aberr_table}
\title{Calculate aberrations table}
\usage{
calculate_aberr_table(
  data,
  type = c("count", "case"),
  aberr_module = c("dicentrics", "translocations", "micronuclei"),
  assessment_u = 1
)
}
\arguments{
\item{data}{Count or case data.}

\item{type}{Type of input data. Either "count" and "case".}

\item{aberr_module}{Aberration module, required for \code{type = "case"}.}

\item{assessment_u}{Expected \eqn{u}-value of the assessment. For a Poisson distribution this should be unity.}
}
\value{
Data frame containing cell count (\eqn{N}), aberrations (\eqn{X}),
and other coefficients (dispersion index, \eqn{u}-value, ...), as well as
raw count or case \code{data}.
}
\description{
Calculate aberrations table
}
\examples{
data <- data.frame(
    ID = c("example1", "example2"),
    C0 = c(302, 160),
    C1 = c(28, 55),
    C2 = c(22, 19),
    C3 = c(8, 17),
    C4 = c(1, 9),
    C5 = c(0, 4)
)


calculate_aberr_table(data,
                      type = "case",
                      aberr_module = "dicentrics",
                      assessment_u = 1)
}
