% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_wos.R
\name{read_wos}
\alias{read_wos}
\title{Read Web of Science exported files}
\usage{
read_wos(file, format = "bib", normalized_names = TRUE)
}
\arguments{
\item{file}{Character scalar or vector. Path(s) to a WoS export file, or a
single URL (\verb{http://} or \verb{https://}) pointing to a WoS export.}

\item{format}{Character scalar. Export format; one of
\code{"bib"}, \code{"ris"}, \code{"txt-plain-text"}, or \code{"txt-tab-delimited"}.}

\item{normalized_names}{Logical. If \code{TRUE} (default), use standardized column
names when possible; if \code{FALSE}, keep original WoS field tags.}
}
\value{
A tibble with the parsed WoS records. See \strong{Details} for notes on
added/coerced columns (\code{DI2}, \code{PY}, \code{DB}) and column ordering.
}
\description{
Parse Web of Science (WoS) export files in multiple formats and return a
tidy table. The function automatically dispatches to a specialized parser
based on the \code{format} argument and can also \strong{download from a URL} if
\code{file} points to an \verb{http://} or \verb{https://} resource.
}
\details{
\itemize{
\item \code{file} may be a single path/URL or a \strong{vector of paths}; multiple files
will be combined row-wise when applicable.
\item When \code{file} is a URL, the file is downloaded to a temporary path before
parsing (a progress message is printed).
\item If \code{normalized_names = TRUE}, selected WoS tags are mapped to standardized
names (e.g., \code{AU} -> \code{author}, \code{TI} -> \code{title}, \code{PY} -> \code{year}, \code{DI} -> \code{doi},
\code{DE} -> \code{keywords}, \code{SR} -> \code{unique_id}, etc.; the exact mapping depends on
the format). Otherwise, original field tags are preserved.
\item The output includes:
\itemize{
\item \code{DI2}: an uppercase, punctuation-stripped variant of \code{DI} (if present),
\item \code{PY}: coerced to numeric (when present),
\item \code{DB}: a provenance flag indicating the source/format and whether names
were normalized.
}
\item Columns with ALL-CAPS tags (e.g., \code{AU}, \code{TI}, \code{PY}) are placed first,
followed by other columns, and \code{DI2} is relocated just after \code{DI}.
}
}
\section{Supported formats}{

\itemize{
\item \code{"bib"} — BibTeX export
\item \code{"ris"} — RIS export
\item \code{"txt-plain-text"} — Plain-text export
\item \code{"txt-tab-delimited"} — Tab-delimited export
}
}

\examples{
bib_file <- system.file("extdata", "sample_wos.bib", package = "birddog")
M <- read_wos(bib_file, format = "bib", normalized_names = TRUE)
head(M)

\dontrun{
# load data from a URL
M <- read_wos("https://example.com/savedrecs.bib", format = "bib")
}

}
\seealso{
Internal parsers used by this function:
\code{\link{read_wos_bib}}, \code{\link{read_wos_ris}},
\code{\link{read_wos_plain}}, \code{\link{read_wos_tab}}.
}
