% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sniff_groups_stm_prepare.R
\name{sniff_groups_stm_prepare}
\alias{sniff_groups_stm_prepare}
\title{Prepare Text Data and Analyze Topic Models}
\usage{
sniff_groups_stm_prepare(
  groups,
  group_to_stm = "g01",
  search_topics = c(5:40, 45, 50, 55, 60),
  seed = 1234,
  cores = 1
)
}
\arguments{
\item{groups}{A list containing network data with a 'network' component}

\item{group_to_stm}{Character string specifying which research group to process (default: 'g01')}

\item{search_topics}{Numeric vector of topic numbers to evaluate (default: c(5:40, 45, 50, 55, 60))}

\item{seed}{Random seed for reproducibility (default: 1234)}

\item{cores}{Number of CPU cores to use (default: 1)}
}
\value{
A list containing:
\itemize{
\item{result: The searchK results object}
\item{plots: A list containing two ggplot objects (p1: metrics by K, p2: exclusivity vs coherence)}
\item{df_prep: Output from stm::textProcessor}
\item{df_doc: Output from stm::prepDocuments}
\item{df: Original filtered data}
}
}
\description{
Processes text data for structural topic modeling and performs topic number selection analysis,
returning both the processed data and diagnostic plots.
}
\examples{
\dontrun{
output <- sniff_groups_stm_prepare(network_data)
output$plots$p1 # View first plot
output$result # Access search results
}

}
