% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-block.R
\name{new_theme_block}
\alias{new_theme_block}
\title{Theme customization block for ggplot2 plots}
\usage{
new_theme_block(
  panel_bg = "",
  plot_bg = "",
  base_size = NA_real_,
  base_family = "auto",
  show_major_grid = "auto",
  show_minor_grid = "auto",
  grid_color = "",
  show_panel_border = "auto",
  legend_position = "auto",
  base_theme = "auto",
  palette_fill = "auto",
  palette_colour = "auto",
  ...
)
}
\arguments{
\item{panel_bg}{Panel background color (default "" uses base theme default)}

\item{plot_bg}{Plot background color (default "" uses base theme default)}

\item{base_size}{Base font size in points
(default NA uses base theme default)}

\item{base_family}{Font family: "auto", "sans", "serif", or "mono"
(default "auto" preserves upstream font)}

\item{show_major_grid}{Show major grid lines: "auto", "show", "hide"
(default "auto" uses base theme default)}

\item{show_minor_grid}{Show minor grid lines: "auto", "show", "hide"
(default "auto" uses base theme default)}

\item{grid_color}{Grid line color
(default "" uses base theme default)}

\item{show_panel_border}{Show panel border: "auto", "show", "hide"
(default "auto" uses base theme default)}

\item{legend_position}{Legend position: "auto", "right", "left", "top",
"bottom", "none" (default "auto" preserves upstream position)}

\item{base_theme}{Base ggplot2 theme: "auto", "minimal", "classic",
"gray", "bw", etc. (default "auto" preserves upstream theme)}

\item{palette_fill}{Color palette for fill aesthetic: "auto" (keep upstream),
"viridis", "magma", "plasma", "inferno", "cividis", or "ggplot2"
(default "auto" preserves upstream palette)}

\item{palette_colour}{Color palette for colour aesthetic: "auto" (keep
upstream), "viridis", "magma", "plasma", "inferno", "cividis", or "ggplot2"
(default "auto" preserves upstream palette)}

\item{...}{Forwarded to \code{\link[blockr.core]{new_transform_block}}}
}
\value{
A ggplot transform block object of class \code{theme_block}.
}
\description{
A block that applies advanced theme customizations to ggplot2 objects.
Allows fine-grained control over backgrounds, fonts, grid lines, and more.
Empty/NULL values will use the base theme's defaults.
}
\examples{
# Create a theme block with classic theme
new_theme_block(base_theme = "classic")

# Create a theme block with custom settings
new_theme_block(
  base_theme = "minimal",
  legend_position = "bottom",
  base_size = 14
)

if (interactive()) {
  library(blockr.core)
  # Theme block requires a ggplot input
  serve(new_theme_block())
}

}
