\name{bpcp-internal}
\alias{abmm}
\alias{kmgw.calc}
\alias{kmci.mid}
\alias{kmci.cons}
\alias{kmConstrain}
\alias{kmcilog}
\alias{kmConstrainBeta.calc}
\alias{create.kmciLR}
\alias{delta.calc}
\alias{calc_sigma}
\alias{kmciDelta}
\alias{bpcp.mm}
\alias{bpcp.mc}
\alias{bpcpMidp.mm}
\alias{getmarks}
\alias{getmarks.x}
\alias{intChar}
\alias{citoLR}
\alias{borkowf.calc}

\alias{meldMC}
\alias{betaMeldTestMidp.mc}
\alias{bpcpTesttime}

\alias{qqbeta}
\alias{uvab}
\alias{rejectFromInt}

\alias{statusCheck}

\alias{parmtype_to_trans}
\alias{twosampleChecks}
\alias{create.htest}
\alias{create.twosamp}
\alias{BtCI}
\alias{calc_eqS1}
\alias{calc_eqS2}
\alias{get_h}
\alias{get_dh}
\alias{get_hinv}
\alias{get_g}
\alias{get_ginv}
\alias{get_all_times}
\alias{zero.one.adjust}


%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Internal functions
}
\description{
Functions  called by other functions. Not to be directly called by user.
}
\usage{
abmm(a1,b1,a2,b2)
kmgw.calc(time, status, keepCens = TRUE)
borkowf.calc(x, type = "log", alpha = 0.05, twosamp_output = FALSE)
kmConstrain(tstar, pstar, x, alpha = 0.05)
kmConstrainBeta.calc(tstar, pstar, x, alpha = 0.05)
create.kmciLR(x, all_times=NULL)
delta.calc(time_g,status_g, all_times=NULL,trans, method, 
                      alpha,zero.one.adjustment,two_samp_out)
calc_sigma(S, V, dh)
kmciDelta(time,status,alpha=.05, 
                      trans=c("none","log","cloglog","logodds","clog","loglog"), 
                      zero.one.adjustment=FALSE,
                      method=c("standard","reg_hybrid",
                                          "adj_hybrid","sh_adj_hybrid"),
                      all_times=NULL)
bpcp.mm(x,alpha=0.05)
bpcp.mc(x,nmc=100,alpha=0.05, testtime=0, DELTA=0, midp=FALSE)
bpcpMidp.mm(x,alpha=0.05, midptol=.Machine$double.eps^0.25)
kmcilog(x, alpha = 0.05)

qqbeta(x, a, b)
rejectFromInt(theta,interval,thetaParm=FALSE)
uvab(u, v)
citoLR(x)

getmarks(time, status)
getmarks.x(x)


intChar(L, R, Lin = rep(FALSE, length(L)), Rin = rep(TRUE, length(L)), 
            digits = NULL)

meldMC(T1,T2, nullparm=NULL, 
    parmtype=c("difference","oddsratio","ratio","cdfratio","logsratio"),
    conf.level=0.95, 
    alternative=c("two.sided","less","greater"),
    dname="",estimate1=NA, estimate2=NA)

betaMeldTestMidp.mc(betaParms1,
    betaParms2,nullparm=NULL, 
    parmtype=c("difference","oddsratio","ratio","cdfratio","logsratio"),
    conf.level=0.95, conf.int=TRUE,
    alternative=c("two.sided","less","greater"),
    dname="",
    estimate1=NA, estimate2=NA, nmc=10^6)
    
bpcpTesttime(x,time, status, group, fit1, fit2, check_args, midp,control, 
              controlMethod)

statusCheck(status)

parmtype_to_trans(parmtype)

twosampleChecks(time, testtime, status, group, alternative, parmtype, method, 
           nullparm, conf.level,changeGroupOrder, method_type=c("delta","bpcp"))

create.htest(testtime,alt,conf.level, lower, upper, p.value, est1, est2, beta,
                nullparm, ptype, ug,method,zero.one.adjustment=FALSE)

create.twosamp(alt,conf.level, L, Lin, R, Rin, interval, g1, est_g1, lower_g1, 
                  upper_g1, g2,est_g2, lower_g2, upper_g2, 
                  beta, lower, upper,p.value,nullparm, ptype, method,
                  zero.one.adjustment=FALSE)

BtCI(x,tstar, ...)

calc_eqS1(S1Est, S2Est, h, phi, Za, S1primeEst, V1Est, S2primeEst, V2Est, dh)

calc_eqS2(method, VEst, VarHs=NULL, ShatStar=NULL, n=NULL)

zero.one.adjust(Shat1, Shat2, method,Shatprime_g1, Shatprime_g2, phi, h, Za, 
                VarEst_g1, VarHs_g1, VarEst_g2,VarHs_g2,
                ShatStar_g1,ShatStar_g2,n1, n2,dh)

get_h(parmtype=NULL, trans=NULL)

get_dh(parmtype=NULL, trans=NULL)

get_hinv(trans)

get_g(parmtype)

get_ginv(parmtype)

get_all_times(time, status, cens_symbol=TRUE)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{a}{ beta shape1 parameter}
  \item{b}{ beta shape2 parameter }
  \item{a1}{first beta shape1 parameter, first of two beta distributions}
  \item{a2}{second beta shape1 parameter, second of two beta distributions}
  \item{b1}{first beta shape2 parameter, first of two beta distributions}
  \item{b2}{second beta shape2 parameter, second of two beta distributions}
  \item{u}{vector of means of beta distributions}
  \item{v}{vector of variances of beta distributions}
  \item{time}{time to event or censoring}
  \item{status}{vector of event status, 1 for events 0 for censoring}
  \item{group}{group for test, should have two levels, to change order use as factor and change order of levels}
  \item{keepCens}{logical, keep times with only censored values?}
  \item{x}{output from kmgw.calc for one-sample functions, a class "twosamp" object for two-sample cases}
  \item{theta}{either the parameter under the null (if thetaParm=TRUE) or an estimate of theta (if thetaParm=FALSE)}
  \item{thetaParm}{logical, is theta a parameter?}
  \item{interval}{either a confidence interval (if thetaParm=TRUE) or quantiles from a null distribution (if thetaParm=FALSE);
  for create.twosamp, it is the interval of survival and confidence intervals as determined by \code{L}, \code{Lin}, \code{R}, \code{Rin}}
  \item{alpha}{1-conf.level}
 \item{testtime}{time for test, needed for output for two-sample test}
\item{midp}{logical, do mid-p tests and/or confidence intervals?}
\item{midptol}{tol value passed to uniroot in function}
\item{DELTA}{same at Delta in bpcp}
  \item{tstar}{time for survival distribution}
  \item{pstar}{null value for survival}
  \item{type}{character describing method, either 'log' transformation, 'logs' log transformation with shift, 'norm' no transformation, 'norms' no transformation with shift }
\item{nmc}{number of Monte Carlo reps}
\item{L}{left end of  intervals associated with each surv and ci value}
\item{R}{right end of  intervals associated with each surv and ci value}
\item{Lin}{logical vector, include left end in interval?}
\item{Rin}{logical vector, include right end in  interval?}
\item{digits}{how many significant digits to use}
\item{T1}{vector of nmc simulated values for parameter from group 1}
\item{T2}{vector of nmc simulated values for parameter from group 2}
\item{nullparm}{null value of the 2 sample parameter, when NULL gives values appropriate for parmtype}
\item{parmtype}{type of parameter for the two sample test, for details see \code{\link{bpcp2samp}}  }
\item{ptype}{type of parameter for the two sample test, for details see \code{\link{bpcp2samp}}  }
\item{conf.level}{confidence level}
\item{conf.int}{logical, calculate confidence interval?}
\item{alternative}{alternative hypothesis}
\item{alt}{alternative hypothesis}
\item{dname}{data name for 'htest' class of the result}
\item{estimate1}{estimate of parameter from group 1}
\item{est1}{estimate of parameter from group 1}
\item{estimate2}{estimate of parameter from group 2}
\item{est2}{estimate of parameter from group 2}
\item{betaParms1}{named list of beta parameters from group 1 (usually come from method of moments), names: alower,blower, aupper, bupper}
\item{betaParms2}{named list of beta parameters from group 2, names: alower,blower, aupper, bupper}
\item{changeGroupOrder}{logical, change the order of the groups?}
\item{method_type}{type of two-sample CI, either "bpcp" or "delta"}
\item{method}{CI method that depends on \code{type}, for bpcp is either "melded" or "midp", for delta is either "standard","reg_hybrid","adj_hybrid", or"sh_adj_hybrid", for details see \code{\link{delta2samp}}}
\item{p.value}{p-value for the test}
\item{beta}{estimate of parameter determined by \code{parmtype}}
\item{lower}{the lower limit of the confidence interval for the parameter determined by \code{parmtype}}
\item{upper}{the upper limit of the confidence interval for the parameter determined by \code{parmtype}}
\item{ug}{character vector of two groups determined by \code{changeGroupOrder}, ug[1] will be group 1, and ug[2] will be group 2}
\item{zero.one.adjustment}{default=FALSE, if true performs ad hoc modifications to the delta method when Kaplan-Meier estimators are 0 or 1.}
\item{h}{transformation function of survival determined by  \code{parmtype}}
\item{dh}{derivative function of \code{h}() determined by \code{parmtype}}
\item{phi}{Equal to 1 when \code{h} is an increasing function (transformation for s is none, log(s), or log(s/(1 . s))); and
equal to -1 when \code{h} is a decreasing function (transformation for s is log(1 . s) or log(.log(s))), in which cases the directions of the confidence interval are switched.}
\item{Za}{alpha level's z-score}
\item{Shat1}{estimates of group 1 survival as determined by \code{method}}
\item{S1Est}{estimates of group 1 survival used in \code{h} based on \code{zero.one.adjustment}}
\item{Shat2}{estimates of group 2 survival as determined by \code{method}}
\item{S2Est}{estimates of group 2 survival used in \code{h} based on \code{zero.one.adjustment}}
\item{VarEst_g1}{estimates of group 1 variance, as determined by \code{method}}
\item{V1Est}{adjusted estimates of group 1 variance when \code{VarEst_g1} = 0}
\item{VarEst_g2}{estimates of group 2 variance, as determined by \code{method}}
\item{V2Est}{adjusted estimates of group 2 variance when \code{VarEst_g2} = 0}
\item{S1primeEst}{estimates of group 1 survival used in sigma calculations, as determined by \code{method} and \code{zero.one.adjustment}}
\item{Shatprime_g1}{estimates of group 1 survival used in sigma calculations, as determined by \code{method} and \code{zero.one.adjustment}}
\item{S2primeEst}{estimates of group 2 survival used in sigma calculations, as determined by \code{method} and \code{zero.one.adjustment}}
\item{Shatprime_g2}{estimates of group 2 survival used in sigma calculations, as determined by \code{method} and \code{zero.one.adjustment}}
\item{VEst}{variance estimates for a given group}
\item{VarHs}{adjusted hybrid variance estimates from Borkowf's method for a given group; only needed to adjust variance for borkowf's methods}
\item{ShatStar}{shrunken estimates of survival from Borkowf's method for a given group; only needed to adjust variance for standard method}
\item{n}{total number at risk at the start for a given group; only needed to adjust variance for standard method}
\item{VarHs_g1}{adjusted hybrid variance estimates from Borkowf's method for group 1}
\item{VarHs_g2}{adjusted hybrid variance estimates from Borkowf's method for group 2}
\item{ShatStar_g1}{shrunken estimates of survival from Borkowf's method for group 1}
\item{ShatStar_g2}{shrunken estimates of survival from Borkowf's method for group 2}
\item{n1}{total number at risk at the start for group 1}
\item{n2}{total number at risk at the start for group 2}
\item{trans}{one-sample survival transformation function, one of "none" (S), "log" (log(S)), "logodds" (log(S/(1-S)), "loglog" (log(-log(S))), "clog" (log(1-S)), or "cloglog" (log(-log(1-S)))}
\item{cens_symbol}{should a "+" be included for the times in which observations were censored?}
\item{fit1}{kmciLRtidy output from \code{\link{bpcp}} for group 1}
\item{fit2}{kmciLRtidy output from \code{\link{bpcp}} for group 2}
\item{check_args}{list output from \code{twosampleChecks} with corrected parmtypes,lower and upper limits, nullparm, alternative hypothesis, group ordering, alpha and conf.level, one-sample transformation, and two-sample method}
\item{control}{control settings, see \code{\link{bpcp2sampControl}}}
\item{controlMethod}{either 'mm.mc' or 'mc.mc', see \code{\link{bpcp2sampControl}}}
\item{time_g}{time to event or censoring for a given group}
\item{status_g}{vector of event status, 1 for events 0 for censoring for a given group}
\item{two_samp_out}{is this being calculated for a two-sample CI?}
\item{S}{estimates of survival}
\item{V}{estimates of variance}
\item{twosamp_output}{whether \code{borkowf.calc} should return output needed for two-sample case (o/w one sample output)}
}
\details{
abmm uses method of moments to find a,b parameters from beta distribution that is product of two other beta RVs.   

kmgw.calc calculates the Kaplan-Meier and Greenwood variances.

kmci.mid and kmci.cons calculate confidence intervals using a new method with either mid-p-like intervals or a conservative interval
from input from kmgw.calc.
 
kmcilog gives normal approximation confidence interval using log transformation.

create.kmciLR creates kmciLR objects from kmgw.calc output.

borkowf.calc calculates the Borkowf intervals from output from kmgw.calc. \code{\link{kmciBorkowf}} creates a kmciLR object from the borkowf.calc output. 
delta.calc runs borkowf's methods on a single sample and returns  KM estimate, shrunken KM estimate, and 3 variance estimates (greenwood, regular hybrid, adjusted hybrid). 
delta.calc is either called by kmciDelta in the one-sample case to create a kmciLR object, or delta2samp in the two-sample case to create either an htest or twosamp object.

calc_sigma calculates the variance estimate for h(S), which is asymptotically normal by the delta method.

bpcp.mm and bpcp.mc are the main calculation functions (.mm for method of moments, .mc for Monte Carlo simulation) 
for bpcp (repeated Beta method). Both output a list with two vectors, upper and lower. bpcpMidp.mm and bpcpMidp.mc are the mid-p versions of these functions. 

kmConstrain gives constrained K-M estimate, and kmConstrainBeta.calc gives ci and tests using Beta distribution. 
 
qqbeta is like qbeta, but allows a=0 (giving a value of 0 when b>0) and b=0 (giving a value of 1 when a>0).

rejectFromInt inputs theta and an interval and gives a vector with 3 terms, estGTnull=1 if reject and estimate is greater than null value,
estLTnull=1 if reject and estimate is less than null value, two.sided=1 if reject in either direction. 
The thetaParm=TRUE means that theta is the parameter under the null so that interval is a confidence interval,
while thetaParm=FALSE means that theta is an estimate of the parameter and interval are quantiles from the null distribution. 

uvab takes means and variances of beta distributions and returns shape parameters. 

statusCheck gives an error for vectors not all either 0 or 1

parmtype_to_trans returns the one-sample transformation (none, logodds, log, etc) based on the two-sample parmtype.

twosampleChecks runs argument checks for the two-sample functions, adjusts group ordering, and calculates lower/upper limit and nullparm based on the parmtype.

create.htest creates a list of class "htest" containing the two-sample results when the testtime is specified.

create.twosamp creates a list of class "twosamp" containing the two-sample results for the intervals corresponding to all distinct times in in the data.

BtCI pulls out beta estimate and CI for given test time(s) from a twosamp object.

calc_eqS1 calculates the 100(1-alpha)\% confidence interval for the delta methods.

calc_eqS2 replaces variance estimates in the 0/1 survival case for the delta methods using Borkowf's adjusted hybrid variance for the three Borkowf methods, and with the shrunken survival estimates for the standard method.

zero.one.adjust finds replacements for beta estimates, lower and upper confidence intervals when survival estimates = 0 or 1. The need and type of adjustment
needed depend on the parmtype and which Borkowf method is used.

get_h retrieves one-sample transformation function for survival, h(S); get_dh and get_hinv retrieve the derivative and the inverse of the transformation function, respectively. 
get_g retrieves the function to calculate the beta estimate from the difference D=h(S2)-h(S1). get_ginv retrieves the inverse of g(D) to find D from the beta estimate.

get_all_times creates a vector of all distinct event times across both groups to test for the twosamp class output of bpcp2samp and delta2samp.

}
%\value{}
%\references{}
\author{Michael Fay}
%\note{%%  ~~further notes~~}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{%% ~~objects to See Also as \code{\link{help}}, ~~~}
%\examples{}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{internal}
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
