% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country_grouping_subregiondetailed.R
\docType{data}
\name{country_grouping_subregiondetailed}
\alias{country_grouping_subregiondetailed}
\title{A vector with country grouping by detailed subregion for 189 countries}
\format{
A numeric vector with values from \code{1} to \code{20}
}
\source{
International Labour Organization. (2020). ILO modelled estimates database, 
ILOSTAT [database]. Available from \url{https://ilostat.ilo.org/data/}.
}
\usage{
data(country_grouping_subregiondetailed)
}
\description{
Each of the country is classified into one of the 20 categories
according to their geographical location. The categories are:
\describe{
  \item{1}{Southern Asia}
  \item{2}{Central Africa}
  \item{3}{Southern Europe}
  \item{4}{Arab States}
  \item{5}{South America}
  \item{6}{Western Asia}
  \item{7}{Pacific Islands}
  \item{8}{Western Europe}
  \item{9}{Eastern Africa}
  \item{10}{Western Africa}
  \item{11}{Eastern Europe}
  \item{12}{Caribbean}
  \item{13}{Central America}
  \item{14}{South-Eastern Asia}
  \item{15}{Southern Africa}
  \item{16}{Northern America}
  \item{17}{Northern Europe}
  \item{18}{Eastern Asia}
  \item{19}{Northern Africa}
  \item{20}{Central Asia}
}
Last data update was implemented on 2025-09-26.
}
\examples{
data(country_grouping_subregiondetailed)   # upload the data

# setup a fixed group allocation Panel VAR model
spec = specify_bvarGroupPANEL$new(
         ilo_dynamic_panel,
         group_allocation = country_grouping_subregiondetailed
)
}
\keyword{datasets}
