% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bvarpanel.R
\name{specify_prior_bvarPANEL}
\alias{specify_prior_bvarPANEL}
\title{R6 Class Representing PriorBVARPANEL}
\description{
The class PriorBVARPANEL presents a prior specification for the Bayesian
hierarchical panel VAR model.
}
\examples{
prior = specify_prior_bvarPANEL$new(C = 2, N = 3, p = 1)
prior$M


## ------------------------------------------------
## Method `specify_prior_bvarPANEL$new`
## ------------------------------------------------

# a prior for 2-country, 3-variable example with one lag and stationary data
prior = specify_prior_bvarPANEL$new(C = 2, N = 3, p = 1)
prior$M


## ------------------------------------------------
## Method `specify_prior_bvarPANEL$get_prior`
## ------------------------------------------------

# a prior for 2-coutnry, 3-variable example with four lags
prior = specify_prior_bvarPANEL$new(C = 2, N = 3, p = 4)
prior$get_prior() # show the prior as list

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{M}}{an \code{KxN} matrix, the mean of the second-level MNIW prior
distribution for the global parameter matrices \eqn{\mathbf{A}} 
and \eqn{\mathbf{V}}}

\item{\code{W}}{a \code{KxK} column-specific covariance matrix of the second-level
MNIW prior distribution for the global parameter matrices \eqn{\mathbf{A}}
and \eqn{\mathbf{V}}}

\item{\code{S_inv}}{an \code{NxN} row-specific precision matrix of the second-level
MNIW prior distribution for the global parameter matrices \eqn{\mathbf{A}}
and \eqn{\mathbf{V}}}

\item{\code{S_Sigma_inv}}{an \code{NxN} precision matrix of the second-level 
Wishart prior distribution for the global parameter matrix \eqn{\mathbf{\Sigma}}.}

\item{\code{eta}}{a positive shape parameter of the second-level MNIW prior distribution
for the global parameter matrices \eqn{\mathbf{A}}
and \eqn{\mathbf{V}}}

\item{\code{mu_Sigma}}{a positive shape parameter of the second-level Wishart prior 
distribution  for the global parameter matrix \eqn{\mathbf{\Sigma}}.}

\item{\code{lambda}}{a positive shape of the second-level exp prior distribution 
for the shape parameter \eqn{\nu}.}

\item{\code{mu_m}}{a scalar mean of the third-level normal prior distribution
for the global average persistence parameter \eqn{m}.}

\item{\code{sigma2_m}}{a positive scalar variance of the third-level normal prior 
distribution for the global average persistence parameter \eqn{m}.}

\item{\code{s_w}}{a positive scalar scale of the third-level gamma prior 
distribution for parameter \eqn{w}.}

\item{\code{a_w}}{a positive scalar shape of the third-level gamma prior 
distribution for parameter \eqn{w}.}

\item{\code{s_s}}{a positive scalar scale parameter of the third-level 
inverted-gamma 2 prior distribution for parameter \eqn{s}.}

\item{\code{nu_s}}{a positive scalar shape parameter of the third-level 
inverted-gamma 2 prior distribution for parameter \eqn{s}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PriorBVARPANEL-new}{\code{specify_prior_bvarPANEL$new()}}
\item \href{#method-PriorBVARPANEL-get_prior}{\code{specify_prior_bvarPANEL$get_prior()}}
\item \href{#method-PriorBVARPANEL-clone}{\code{specify_prior_bvarPANEL$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PriorBVARPANEL-new"></a>}}
\if{latex}{\out{\hypertarget{method-PriorBVARPANEL-new}{}}}
\subsection{Method \code{new()}}{
Create a new prior specification PriorBVARPANEL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_prior_bvarPANEL$new(C, N, p, d = 0, stationary = rep(FALSE, N))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{a positive integer - the number of countries in the data.}

\item{\code{N}}{a positive integer - the number of dependent variables in the model.}

\item{\code{p}}{a positive integer - the autoregressive lag order of the SVAR model.}

\item{\code{d}}{a positive integer - the number of \code{exogenous} variables in the model.}

\item{\code{stationary}}{an \code{N} logical vector - its element set to 
\code{FALSE} sets the prior mean for the autoregressive parameters of the 
\code{N}th equation to the white noise process, otherwise to random walk.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new prior specification PriorBVARPANEL.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# a prior for 2-country, 3-variable example with one lag and stationary data
prior = specify_prior_bvarPANEL$new(C = 2, N = 3, p = 1)
prior$M

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PriorBVARPANEL-get_prior"></a>}}
\if{latex}{\out{\hypertarget{method-PriorBVARPANEL-get_prior}{}}}
\subsection{Method \code{get_prior()}}{
Returns the elements of the prior specification PriorBSVAR as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_prior_bvarPANEL$get_prior()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# a prior for 2-coutnry, 3-variable example with four lags
prior = specify_prior_bvarPANEL$new(C = 2, N = 3, p = 4)
prior$get_prior() # show the prior as list

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PriorBVARPANEL-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PriorBVARPANEL-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_prior_bvarPANEL$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
