% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament_api.R
\name{build}
\alias{build}
\title{Build a live tournament runtime from a specification}
\usage{
build(x, participants)
}
\arguments{
\item{x}{A \code{bracketeer_spec} or \code{tournament_spec} object.}

\item{participants}{Character vector of participant names, or a data.frame
with a \code{name} column.}
}
\value{
A tournament runtime object.
}
\description{
Build a live tournament runtime from a specification
}
\examples{
my_spec <- spec() |>
  swiss("open", rounds = 3) |>
  single_elim("playoffs", take = top_n(4))

# Materialize with participants
trn <- build(my_spec, paste("Team", LETTERS[1:8]))
}
