% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{brand_pluck}
\alias{brand_pluck}
\title{Extract a nested element from a brand object}
\usage{
brand_pluck(brand, ...)
}
\arguments{
\item{brand}{A brand object created by \code{\link[=read_brand_yml]{read_brand_yml()}} or
\code{\link[=as_brand_yml]{as_brand_yml()}}.}

\item{...}{One or more character strings or symbols representing the path to
the nested element.}
}
\value{
The value of the nested element if it exists, \code{NULL} otherwise.
}
\description{
Safely extracts a nested element from a \code{brand} object using the provided key
path. Returns \code{NULL} if the element doesn't exist.
}
\examples{
brand <- as_brand_yml(list(
  meta = list(name = "Example Brand"),
  color = list(primary = "#FF5733")
))

# Extract the primary color
brand_pluck(brand, "color", "primary") # "#FF5733"

# Try to extract a non-existent element
brand_pluck(brand, "color", "secondary") # NULL

}
\seealso{
Other brand.yml helpers: 
\code{\link{brand_color_pluck}()},
\code{\link{brand_has}()},
\code{\link{with_brand_yml_path}()}
}
\concept{brand.yml helpers}
