#' Standardized International Exchange Rate Changes from 1975 to 1986
#'
#' This data set contains the changes in monthly international exchange rates for pounds sterling from January 1975 to December 1986 obtained from West and Harrison (1997, pp. 612-615). Currencies tracked are US Dollar (column \code{us_dollar}), Canadian Dollar (column \code{canadian_dollar}), Japanese Yen (column \code{yen}), French Franc (column \code{franc}), Italian Lira (column \code{lira}), and the (West) German Mark (column \code{mark}). Each series has been standardized with respect to its sample mean and standard deviation.
#'
#' @docType data
#' @keywords dataset
#' @name ier
#' @usage ier
#' @format A matrix with 143 rows and 6 columns.
#' @source West, M., Harrison, J. (1997). \emph{Bayesian forecasting and dynamic models} (2nd ed.). Springer-Verlag, New York.
#'
#' Lopes, H. F., West, M. (2004). Bayesian model assessment in factor analysis. \emph{Statistica Sinica, 14}, 41-67.
#' @encoding UTF-8
#'
#' @example examples/example.ier.R
NULL
