% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_cplx.R
\name{bc.cplx}
\alias{bc.cplx}
\alias{bc.cplx,ANY-method}
\title{Broadcasted Complex Numeric Operations}
\usage{
bc.cplx(x, y, op, ...)

\S4method{bc.cplx}{ANY}(x, y, op)
}
\arguments{
\item{x, y}{conformable vectors/arrays of type \code{complex}.}

\item{op}{a single string, giving the operator. \cr
Supported arithmetic operators: +, -, *, /. \cr
Supported relational operators: ==, !=.}

\item{...}{further arguments passed to or from methods. \cr \cr}
}
\value{
For arithmetic operators: \cr
A complex array as a result of the broadcasted arithmetic operation. \cr
\cr
For relational operators: \cr
A logical array as a result of the broadcasted relational comparison. \cr
\cr
}
\description{
The \code{bc.cplx()} function performs broadcasted complex numeric operations on pairs of arrays. \cr
\cr
}
\details{
For the \code{*} and \code{/} operators, \code{bc.cplx()} uses more strict \code{NA} checks than base 'R': \cr
If for an iteration,
\code{re(x)}, \code{im(x)}, \code{re(y)}, and/or \code{im(y)} contains \code{NA},
than the result for that iteration is necessarily \code{NA_complex_}.
}
\examples{
x.dim <- c(4:2)
x.len <- prod(x.dim)
gen <- function() sample(c(rnorm(20), NA, NaN, Inf, -Inf))
x <- array(gen() + gen() * -1i, x.dim)
y <- array(gen() + gen() * -1i, c(4,1,1))

bc.cplx(x, y, "==")
bc.cplx(x, y, "!=")

bc.cplx(x, y, "+")

bc.cplx(array(gen() + gen() * -1i), array(gen() + gen() * -1i), "==")
bc.cplx(array(gen() + gen() * -1i), array(gen() + gen() * -1i), "!=")

x <- array(gen() + gen() * -1i)
y <- array(gen() + gen() * -1i)
bcr(x) <- bcr(y) <- TRUE
out <- x * y
bind_array(list(x = x, y = y, `x*y` = x*y, out = out), 2L)
}
\seealso{
\link{broadcast_operators} \cr
}
