% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfilter.R
\name{ekf}
\alias{ekf}
\title{(Iterated) Extended Kalman Filtering}
\usage{
ekf(model, iekf_iter = 0)
}
\arguments{
\item{model}{Model of class \code{ssm_nlg}.}

\item{iekf_iter}{Non-negative integer. The default zero corresponds to
normal EKF, whereas \code{iekf_iter > 0} corresponds to iterated EKF
with \code{iekf_iter} iterations.}
}
\value{
List containing the log-likelihood,
one-step-ahead predictions \code{at} and filtered
estimates \code{att} of states, and the corresponding variances \code{Pt} and
\code{Ptt}.
}
\description{
Function \code{ekf} runs the (iterated) extended Kalman filter for the given
non-linear Gaussian model of class \code{ssm_nlg},
and returns the filtered estimates and one-step-ahead predictions of the
states \eqn{\alpha_t} given the data up to time \eqn{t}.
}
\examples{
\donttest{ # Takes a while on CRAN
set.seed(1)
mu <- -0.2
rho <- 0.7
sigma_y <- 0.1
sigma_x <- 1
x <- numeric(50)
x[1] <- rnorm(1, mu, sigma_x / sqrt(1 - rho^2))
for(i in 2:length(x)) {
  x[i] <- rnorm(1, mu * (1 - rho) + rho * x[i - 1], sigma_x)
}
y <- rnorm(50, exp(x), sigma_y)

pntrs <- cpp_example_model("nlg_ar_exp")

model_nlg <- ssm_nlg(y = y, a1 = pntrs$a1, P1 = pntrs$P1, 
  Z = pntrs$Z_fn, H = pntrs$H_fn, T = pntrs$T_fn, R = pntrs$R_fn, 
  Z_gn = pntrs$Z_gn, T_gn = pntrs$T_gn,
  theta = c(mu= mu, rho = rho, 
    log_sigma_x = log(sigma_x), log_sigma_y = log(sigma_y)), 
  log_prior_pdf = pntrs$log_prior_pdf,
  n_states = 1, n_etas = 1, state_names = "state")

out_ekf <- ekf(model_nlg, iekf_iter = 0)
out_iekf <- ekf(model_nlg, iekf_iter = 5)
ts.plot(cbind(x, out_ekf$att, out_iekf$att), col = 1:3)
}
}
