% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_tidy.R
\name{bunddev_call_tidy}
\alias{bunddev_call_tidy}
\title{Call an API operation and return tidy data}
\usage{
bunddev_call_tidy(api, operation_id, params = list(), ...)
}
\arguments{
\item{api}{Registry id.}

\item{operation_id}{OpenAPI operationId.}

\item{params}{List of parameters.}

\item{...}{Additional arguments passed to the tidier.}
}
\value{
A tibble with tidied results.
}
\description{
Call an API operation and return tidy data
}
\details{
This helper calls \code{\link[=bunddev_call]{bunddev_call()}} and then applies the adapter-specific
tidier for the API. If no tidier is registered, a tibble containing the raw
response is returned.
}
\examples{
\dontrun{
# Tidy Autobahn roadworks
bunddev_call_tidy("autobahn", "list-roadworks", params = list(roadId = "A1"))
}

}
\seealso{
\code{\link[=bunddev_call]{bunddev_call()}} for raw responses, and \code{\link[=bunddev_parameters]{bunddev_parameters()}} to discover
available parameters.
}
