% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c5.R
\name{axe-C5.0}
\alias{axe-C5.0}
\alias{axe_call.C5.0}
\alias{axe_ctrl.C5.0}
\alias{axe_fitted.C5.0}
\title{Axing a C5.0.}
\usage{
\method{axe_call}{C5.0}(x, verbose = FALSE, ...)

\method{axe_ctrl}{C5.0}(x, verbose = FALSE, ...)

\method{axe_fitted}{C5.0}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed C5.0 object.
}
\description{
C5.0 objects are created from the \code{C50} package, which provides an
interface to the C5.0 classification model. The models that can be
generated include basic tree-based models as well as rule-based models.
}
\examples{
\dontshow{if (rlang::is_installed(c("parsnip", "rsample", "rpart"))) withAutoprint(\{ # examplesIf}
# Load libraries
library(parsnip)
library(rsample)
library(rpart)

# Load data
set.seed(1234)
split <- initial_split(kyphosis, prop = 9/10)
spine_train <- training(split)

# Create model and fit
c5_fit <- decision_tree(mode = "classification") |>
  set_engine("C5.0") |>
  fit(Kyphosis ~ ., data = spine_train)

out <- butcher(c5_fit, verbose = TRUE)

# Try another model from parsnip
c5_fit2 <- boost_tree(mode = "classification", trees = 100) |>
  set_engine("C5.0") |>
  fit(Kyphosis ~ ., data = spine_train)
out <- butcher(c5_fit2, verbose = TRUE)

# Create model object from original library
library(C50)
library(modeldata)
data(mlc_churn)
c5_fit3 <- C5.0(x = mlc_churn[, -20], y = mlc_churn$churn)
out <- butcher(c5_fit3, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
