% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fit.R
\name{axe-model_fit}
\alias{axe-model_fit}
\alias{axe_call.model_fit}
\alias{axe_ctrl.model_fit}
\alias{axe_data.model_fit}
\alias{axe_env.model_fit}
\alias{axe_fitted.model_fit}
\title{Axing an model_fit.}
\usage{
\method{axe_call}{model_fit}(x, verbose = FALSE, ...)

\method{axe_ctrl}{model_fit}(x, verbose = FALSE, ...)

\method{axe_data}{model_fit}(x, verbose = FALSE, ...)

\method{axe_env}{model_fit}(x, verbose = FALSE, ...)

\method{axe_fitted}{model_fit}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed model_fit object.
}
\description{
model_fit objects are created from the \code{parsnip} package.
}
\examples{
\dontshow{if (rlang::is_installed(c("parsnip", "mgcv"))) withAutoprint(\{ # examplesIf}
library(parsnip)
library(rpart)

# Create model and fit
lm_fit <- linear_reg() |>
  set_engine("lm") |>
  fit(mpg ~ ., data = mtcars)

out <- butcher(lm_fit, verbose = TRUE)

# Another parsnip model
gam_fit <- gen_additive_mod() |>
  set_mode("regression") |>
  fit(mpg ~ s(disp) + wt + gear, data = mtcars)

out <- butcher(gam_fit, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
