% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axe-generics.R, R/rsample-data.R
\name{axe-rsample-data}
\alias{axe-rsample-data}
\alias{axe_rsample_data}
\alias{axe_rsample_data.default}
\alias{axe_rsample_data.rsplit}
\alias{axe_rsample_data.three_way_split}
\alias{axe_rsample_data.rset}
\alias{axe_rsample_data.tune_results}
\alias{axe_rsample_data.workflow_set}
\title{Axe data within rsample objects.}
\usage{
axe_rsample_data(x, verbose = FALSE, ...)

\method{axe_rsample_data}{default}(x, verbose = FALSE, ...)

\method{axe_rsample_data}{rsplit}(x, verbose = FALSE, ...)

\method{axe_rsample_data}{three_way_split}(x, verbose = FALSE, ...)

\method{axe_rsample_data}{rset}(x, verbose = FALSE, ...)

\method{axe_rsample_data}{tune_results}(x, verbose = FALSE, ...)

\method{axe_rsample_data}{workflow_set}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{An object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
An updated object without data in the \code{rsplit} objects.
}
\description{
Replace the splitting and resampling objects with a placeholder.
}
\details{
Resampling and splitting objects produced by \pkg{rsample} contain \code{rsplit}
objects. These contain the original data set. These data might be large so
we sometimes wish to remove them when saving objects. This method creates a
zero-row slice of the dataset, retaining only the column names and their
attributes, while replacing the original data.
}
\section{Methods}{

See the following help topics for more details about individual methods:

\code{butcher}
\itemize{
\item \code{\link[butcher]{axe-rsample-data}}: \code{default}, \code{rset},
\code{rsplit}, \code{three_way_split}, \code{tune_results},
\code{workflow_set}
}
}

\examples{
\dontshow{if (rlang::is_installed("rsample")) withAutoprint(\{ # examplesIf}

large_cars <- mtcars[rep(1:32, 50), ]
large_cars_split <- rsample::initial_split(large_cars)
butcher(large_cars_split, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
