% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cancerradar_output_02.R
\name{read_cancerradar_output_02}
\alias{read_cancerradar_output_02}
\title{Read cancer registry summary statistics (age-specific incidence rate and proportional rates)}
\usage{
read_cancerradar_output_02(filename.out, aggr.level = "cob_iso3")
}
\arguments{
\item{filename.out}{file path, the path to a cancer RADAR output file}

\item{aggr.level}{character, the aggregation level to be considered. Should be one of \code{cob_iso3}
(country of birth; smaller unit), \code{un_region} (UN region), \code{un_subergion} (
UN sub-region), \code{hdi_cat} (HDI category), \code{asr_rank_cat} (cancer burden category
in the country of birth), \code{any_migr} (any migration background)}
}
\value{
a tibble with 11 columns
\itemize{
\item reg_label: factor, the chosen aggregation level id
\item sex: character, male/female
\item ageg: character, age group (here \code{total})
\item can: character, the cancer type
\item index: character, the type of index
\item est: dbl, the index estimator
\item lci: dbl, the index confidence interval lower bound
\item uci: dbl, the index confidence interval upper bound
\item ageg_sta: dbl, the age group starting age
\item ageg_sto: dbl, the age group stopping age
\item ageg_mid: dbl, the age group middle age
}
}
\description{
Read cancer registry summary statistics (age-specific incidence rate and proportional rates)
}
\examples{
filename.out <- system.file('extdata/ex_cancerRADAR_output.xlsx', package = "cancerradarr")
dat.out <- read_cancerradar_output_02(filename.out, 'un_region')
head(dat.out)


}
