% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrome.R
\name{cleanup_chromote_session}
\alias{cleanup_chromote_session}
\title{Safely close a Chromote session}
\usage{
cleanup_chromote_session(session, timeout_before = 2, timeout_after = 1)
}
\arguments{
\item{session}{A ChromoteSession object to close.}

\item{timeout_before}{Seconds to wait for pending promises before closing (default 2).}

\item{timeout_after}{Seconds to wait for cleanup after closing (default 1).}
}
\value{
NULL (invisibly). Called for side effects.
}
\description{
Closes a chromote session handling pending promises to avoid
"Unhandled promise error: timed out waiting for response" warnings.
This function processes pending async operations before closing
and silently ignores any timeout errors during cleanup.
}
\keyword{internal}
