% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrome.R
\name{svg_to_png_chrome}
\alias{svg_to_png_chrome}
\title{Convert SVG to PNG using headless Chrome}
\usage{
svg_to_png_chrome(
  svg_input,
  output_path = NULL,
  dpi = 300,
  background = "transparent",
  load_wait = 0.5
)
}
\arguments{
\item{svg_input}{SVG string or path to an SVG file.}

\item{output_path}{Output path for the PNG file. If NULL, a temp file is used.}

\item{dpi}{Resolution in dots per inch (default 300). Chrome uses 96 DPI as base,
so dpi = 300 results in approximately 3.125x scaling.}

\item{background}{Background color for the HTML page (default "transparent").
Use "white", "#FFFFFF", etc. for a solid background.}

\item{load_wait}{Seconds to wait for page to load (default 0.5).
Increase if fonts are not rendering correctly.}
}
\value{
Path to the generated PNG file.
}
\description{
Renders an SVG to PNG using headless Chrome via the chromote package.
This method provides superior font rendering compared to librsvg/ImageMagick,
as Chrome properly handles @font-face rules, web fonts, and CSS features.
}
\examples{
svg <- svg_card("FAR", list(), list())
file_name <- tempfile(fileext = ".png")
\dontrun{
if (chrome_available()) {
  png_path <- svg_to_png_chrome(svg, file_name, dpi = 300)
}
}
}
