% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_kruskal_test.R
\name{ard_stats_kruskal_test}
\alias{ard_stats_kruskal_test}
\title{ARD Kruskal-Wallis Test}
\usage{
ard_stats_kruskal_test(data, by, variables)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to be compared. Independent tests will
be computed for each variable.}
}
\value{
ARD data frame
}
\description{
Analysis results data for Kruskal-Wallis Rank Sum Test.

Calculated with \code{kruskal.test(data[[variable]], data[[by]], ...)}
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom"))) withAutoprint(\{ # examplesIf}
cards::ADSL |>
  ard_stats_kruskal_test(by = "ARM", variables = "AGE")
\dontshow{\}) # examplesIf}
}
