% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer_sdm.R
\name{buffer_sdm}
\alias{buffer_sdm}
\title{Create buffer around occurrences}
\usage{
buffer_sdm(occ_data, size = NULL, crs = NULL)
}
\arguments{
\item{occ_data}{A \code{data.frame} object with species, decimalLongitude and decimalLatitude columns.
Usually the output from \code{GBIF_data}.}

\item{size}{\code{numeric}. The distance between the record and the margin of the buffer (i.e.
buffer radius).}

\item{crs}{\code{numeric}. Indicates which EPSG it the \code{occ_data} in.}
}
\value{
A \code{sf} buffer around \code{occ_data} records.
}
\description{
Create buffer around records in \code{occ_data} to be used as study area
}
\examples{
# Create sdm_area object:
study_area <- buffer_sdm(occ, size=50000, crs=6933)
plot(study_area)

}
\seealso{
\code{\link{GBIF_data}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
