% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_mem.R
\name{use_mem}
\alias{use_mem}
\title{MacroEcological Models (MEM) in caretSDM}
\usage{
use_mem(x, add = TRUE, name = "MEM")
}
\arguments{
\item{x}{A \code{occurrences} or \code{input_sdm} object containing occurrences.}

\item{add}{Logical. Should the new MEM records be added to the pool (\code{TRUE}) of species or
the output should have only the summed records (\code{FALSE})? Standard is \code{TRUE}.}

\item{name}{How should the new records be named? Standard is "MEM".}
}
\value{
A \code{input_sdm} or \code{occurrences} object with MEM data.
}
\description{
This function sums all species records into one.
Should be used before the data cleaning routine.
}
\examples{
# Create sdm_area object:
sa <- sdm_area(parana, cell_size = 25000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio4", "bio12"))

# Include scenarios:
sa <- add_scenarios(sa)

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Use MEM:
i <- use_mem(i)

}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
