% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_clean.R
\name{data_clean}
\alias{data_clean}
\title{Presence data cleaning routine}
\usage{
data_clean(occ, pred = NULL,
           species = NA, lon = NA, lat = NA,
           capitals = TRUE,
           centroids = TRUE,
           duplicated = TRUE,
           identical = TRUE,
           institutions = TRUE,
           invalid = TRUE,
           terrestrial = TRUE,
           independent_test = TRUE)
}
\arguments{
\item{occ}{A \code{occurrences_sdm} object or \code{input_sdm}.}

\item{pred}{A \code{sdm_area} object. If \code{occ} is a \code{input_sdm} object with
predictors data, than \code{pred} is obtained from it.}

\item{species}{A \code{character} stating the name of the column with species names in \code{occ} (see details).}

\item{lon}{A \code{character} stating the name of the column with longitude in \code{occ} (see details).}

\item{lat}{A \code{character} stating the name of the column with latitude in \code{occ} (see details).}

\item{capitals}{Boolean to turn on/off the exclusion from countries capitals coordinates (see \code{?cc_cap})}

\item{centroids}{Boolean to turn on/off the exclusion from countries centroids coordinates (see \code{?cc_cen})}

\item{duplicated}{Boolean to turn on/off the exclusion from duplicated records (see \code{?cc_dupl})}

\item{identical}{Boolean to turn on/off the exclusion from records with identical lat/long values (see \code{?cc_equ})}

\item{institutions}{Boolean to turn on/off the exclusion from biodiversity institutions coordinates (see \code{?cc_inst})}

\item{invalid}{Boolean to turn on/off the exclusion from invalid coordinates (see \code{?cc_val})}

\item{terrestrial}{Boolean to turn on/off the exclusion from coordinates falling on sea (see \code{?cc_sea})}

\item{independent_test}{Boolean. If \code{occ} has independent test data, the data cleaning routine
is also applied on it.}
}
\value{
A \code{occurrences_sdm} object or \code{input_sdm} with cleaned presence data.
}
\description{
Data cleaning wrapper using CoordinateCleaner package.
}
\details{
If the user does not used \code{GBIF_data} function to obtain species records, the function may
have problems to find which column from the presences table has species, longitude and latitude
information. In this regard, we implemented the parameters \code{species}, \code{lon} and
\code{lat} so the use can explicitly inform which columns should be used. If they remain as NA
(standard) the function will try to guess which columns are the correct one.
}
\examples{
# Create sdm_area object:
sa <- sdm_area(parana, cell_size = 50000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio12"))

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Clean coordinates (terrestrial is set to false to make the run quicker):
i <- data_clean(i, terrestrial = FALSE)

}
\seealso{
\code{\link{GBIF_data} \link{occurrences_sdm} \link{sdm_area} \link{input_sdm}
\link{predictors}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
