% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustment.R
\name{adjustment_set}
\alias{adjustment_set}
\title{Compute an adjustment set}
\usage{
adjustment_set(
  cg,
  X = NULL,
  Y = NULL,
  X_index = NULL,
  Y_index = NULL,
  type = c("optimal", "parents", "backdoor")
)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{X, Y}{Node names.}

\item{X_index, Y_index}{Optional numeric 1-based indices.}

\item{type}{One of \code{"parents"}, \code{"backdoor"}, \code{"optimal"}.
The \code{optimal} option computes the O-set.}
}
\value{
A character vector of node names representing the adjustment set.
}
\description{
Computes an adjustment set for \code{X -> Y} in a DAG.
}
\details{
Types supported:
\itemize{
\item \code{"parents"}: \eqn{\bigcup \mathrm{Pa}(X)} minus \eqn{X \cup Y}
\item \code{"backdoor"}: Pearl backdoor formula
\item \code{"optimal"}: O-set (only for single \code{x} and single \code{y})
}
}
\examples{
cg <- caugi(
  C \%-->\% X,
  X \%-->\% F,
  X \%-->\% D,
  A \%-->\% X,
  A \%-->\% K,
  K \%-->\% Y,
  D \%-->\% Y,
  D \%-->\% G,
  Y \%-->\% H,
  class = "DAG"
)

adjustment_set(cg, "X", "Y", type = "parents") # C, A
adjustment_set(cg, "X", "Y", type = "backdoor") # C, A
adjustment_set(cg, "X", "Y", type = "optimal") # K

}
\seealso{
Other adjustment: 
\code{\link{all_backdoor_sets}()},
\code{\link{d_separated}()},
\code{\link{is_valid_backdoor}()}
}
\concept{adjustment}
