% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustment.R
\name{d_separated}
\alias{d_separated}
\title{Are X and Y d-separated given Z?}
\usage{
d_separated(
  cg,
  X = NULL,
  Y = NULL,
  Z = NULL,
  X_index = NULL,
  Y_index = NULL,
  Z_index = NULL
)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{X, Y, Z}{Node selectors: character vector of names, unquoted expression
(supports \code{+} and \code{c()}), or \code{NULL}. Use \verb{*_index} to pass 1-based indices.
If \code{Z} is \code{NULL} or missing, no nodes are conditioned on.}

\item{X_index, Y_index, Z_index}{Optional numeric 1-based indices (exclusive
with \code{X},\code{Y},\code{Z} respectively).}
}
\value{
\code{TRUE} if d-separated, \code{FALSE} otherwise.
}
\description{
Checks whether every node in \code{X} is d-separated from every node
in \code{Y} given \code{Z} in a DAG.
}
\examples{
cg <- caugi(
  C \%-->\% X,
  X \%-->\% F,
  X \%-->\% D,
  A \%-->\% X,
  A \%-->\% K,
  K \%-->\% Y,
  D \%-->\% Y,
  D \%-->\% G,
  Y \%-->\% H,
  class = "DAG"
)

d_separated(cg, "X", "Y", Z = c("A", "D")) # TRUE
d_separated(cg, "X", "Y", Z = NULL) # FALSE

}
\seealso{
Other adjustment: 
\code{\link{adjustment_set}()},
\code{\link{all_backdoor_sets}()},
\code{\link{is_valid_backdoor}()}
}
\concept{adjustment}
